%------------------------------------------------------------------------------
% File     : ITP199^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer USubst problem prob_1246__6349986_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : USubst/prob_1246__6349986_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v8.1.0, 0.25 v7.5.0
% Syntax   : Number of formulae    :  373 ( 160 unt;  71 typ;   0 def)
%            Number of atoms       :  698 ( 380 equ;   0 cnn)
%            Maximal formula atoms :    9 (   2 avg)
%            Number of connectives : 3287 (  80   ~;  14   |;  43   &;2948   @)
%                                         (   0 <=>; 202  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   6 avg)
%            Number of types       :    9 (   8 usr)
%            Number of type conns  :  354 ( 354   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   66 (  63 usr;   7 con; 0-7 aty)
%            Number of variables   :  900 (  58   ^; 791   !;  14   ?; 900   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:22:53.994
%------------------------------------------------------------------------------
% Could-be-implicit typings (11)
thf(ty_t_Denotational__Semantics_Ointerp,type,
    denotational_interp: $tType ).

thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Syntax_Ovariable,type,
    variable: $tType ).

thf(ty_t_Option_Ooption,type,
    option: $tType > $tType ).

thf(ty_t_Syntax_Ogame,type,
    game: $tType ).

thf(ty_t_String_Ochar,type,
    char: $tType ).

thf(ty_t_Syntax_Otrm,type,
    trm: $tType ).

thf(ty_t_Syntax_Ofml,type,
    fml: $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (60)
thf(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Obounded__semilattice__sup__bot,type,
    bounde1808546759up_bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_c_Coincidence_Ostatediff,type,
    statediff: ( variable > real ) > ( variable > real ) > ( set @ variable ) ).

thf(sy_c_Coincidence_Ostateinterpol,type,
    stateinterpol: ( variable > real ) > ( variable > real ) > ( set @ variable ) > variable > real ).

thf(sy_c_Denotational__Semantics_OUvariation,type,
    denota1419872369iation: ( variable > real ) > ( variable > real ) > ( set @ variable ) > $o ).

thf(sy_c_Denotational__Semantics_OVagree,type,
    denotational_Vagree: ( variable > real ) > ( variable > real ) > ( set @ variable ) > $o ).

thf(sy_c_Denotational__Semantics_Orepv,type,
    denotational_repv: ( variable > real ) > variable > real > variable > real ).

thf(sy_c_Denotational__Semantics_Osolves__ODE,type,
    denota1778088425es_ODE: denotational_interp > ( real > variable > real ) > char > trm > $o ).

thf(sy_c_Denotational__Semantics_Oterm__sem,type,
    denota1863255036rm_sem: denotational_interp > trm > ( variable > real ) > real ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : ( option @ A ) ).

thf(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : ( A > ( option @ A ) ) ).

thf(sy_c_Option_Ooption_Ocase__option,type,
    case_option: 
      !>[B: $tType,A: $tType] : ( B > ( A > B ) > ( option @ A ) > B ) ).

thf(sy_c_Option_Ooption_Oset__option,type,
    set_option: 
      !>[A: $tType] : ( ( option @ A ) > ( set @ A ) ) ).

thf(sy_c_Option_Ooption_Othe,type,
    the: 
      !>[A: $tType] : ( ( option @ A ) > A ) ).

thf(sy_c_Option_Othese,type,
    these: 
      !>[A: $tType] : ( ( set @ ( option @ A ) ) > ( set @ A ) ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Static__Semantics_OFVT,type,
    static_FVT: trm > ( set @ variable ) ).

thf(sy_c_Static__Semantics_Oselectlike,type,
    static_selectlike: ( set @ ( variable > real ) ) > ( variable > real ) > ( set @ variable ) > ( set @ ( variable > real ) ) ).

thf(sy_c_Syntax_Otrm_OTimes,type,
    times: trm > trm > trm ).

thf(sy_c_Syntax_Ovariable_ODVar,type,
    dVar: char > variable ).

thf(sy_c_Syntax_Ovariable_ORVar,type,
    rVar: char > variable ).

thf(sy_c_Syntax_Ovariable_Orec__variable,type,
    rec_variable: 
      !>[A: $tType] : ( ( char > A ) > ( char > A ) > variable > A ) ).

thf(sy_c_Syntax_Ovariable_Osize__variable,type,
    size_variable: variable > nat ).

thf(sy_c_USubst__Mirabelle__nnnzepxswx_OTimeso,type,
    uSubst277968634Timeso: ( option @ trm ) > ( option @ trm ) > ( option @ trm ) ).

thf(sy_c_USubst__Mirabelle__nnnzepxswx_Oadjoint,type,
    uSubst2091380086djoint: ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ) ) > denotational_interp > ( variable > real ) > denotational_interp ).

thf(sy_c_USubst__Mirabelle__nnnzepxswx_Ousubstappt,type,
    uSubst95898992stappt: ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ) ) > ( set @ variable ) > trm > ( option @ trm ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_F,type,
    f: real > variable > real ).

thf(sy_v_I,type,
    i: denotational_interp ).

thf(sy_v_U,type,
    u: set @ variable ).

thf(sy_v__092_060omega_062,type,
    omega: variable > real ).

thf(sy_v__092_060sigma_062,type,
    sigma: product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ) ).

thf(sy_v__092_060theta_062,type,
    theta: trm ).

thf(sy_v_rr____,type,
    rr: trm > denotational_interp > trm > denotational_interp > char > ( real > variable > real ) > variable > real ).

thf(sy_v_x,type,
    x: char ).

% Relevant facts (254)
thf(fact_0_uv,axiom,
    denota1419872369iation @ ( f @ ( zero_zero @ real ) ) @ omega @ ( sup_sup @ ( set @ variable ) @ u @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) ).

% uv
thf(fact_1_Uvariation__empty,axiom,
    ! [Nu: variable > real,Nu2: variable > real] :
      ( ( denota1419872369iation @ Nu @ Nu2 @ ( bot_bot @ ( set @ variable ) ) )
      = ( Nu = Nu2 ) ) ).

% Uvariation_empty
thf(fact_2_Un__insert__left,axiom,
    ! [A: $tType,A2: A,B2: set @ A,C: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( insert @ A @ A2 @ B2 ) @ C )
      = ( insert @ A @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) ) ) ).

% Un_insert_left
thf(fact_3_Un__insert__right,axiom,
    ! [A: $tType,A3: set @ A,A2: A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ B2 ) )
      = ( insert @ A @ A2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) ) ) ).

% Un_insert_right
thf(fact_4_Un__empty,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A] :
      ( ( ( sup_sup @ ( set @ A ) @ A3 @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ( A3
          = ( bot_bot @ ( set @ A ) ) )
        & ( B2
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Un_empty
thf(fact_5_sup__bot__left,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ X )
          = X ) ) ).

% sup_bot_left
thf(fact_6_sup__bot__right,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ ( bot_bot @ A ) )
          = X ) ) ).

% sup_bot_right
thf(fact_7_bot__eq__sup__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A,Y: A] :
          ( ( ( bot_bot @ A )
            = ( sup_sup @ A @ X @ Y ) )
          = ( ( X
              = ( bot_bot @ A ) )
            & ( Y
              = ( bot_bot @ A ) ) ) ) ) ).

% bot_eq_sup_iff
thf(fact_8_sup__eq__bot__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A,Y: A] :
          ( ( ( sup_sup @ A @ X @ Y )
            = ( bot_bot @ A ) )
          = ( ( X
              = ( bot_bot @ A ) )
            & ( Y
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_eq_bot_iff
thf(fact_9_sup__bot_Oeq__neutr__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A2: A,B3: A] :
          ( ( ( sup_sup @ A @ A2 @ B3 )
            = ( bot_bot @ A ) )
          = ( ( A2
              = ( bot_bot @ A ) )
            & ( B3
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_bot.eq_neutr_iff
thf(fact_10_sup__bot_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A2: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ A2 )
          = A2 ) ) ).

% sup_bot.left_neutral
thf(fact_11_sup__bot_Oneutr__eq__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A2: A,B3: A] :
          ( ( ( bot_bot @ A )
            = ( sup_sup @ A @ A2 @ B3 ) )
          = ( ( A2
              = ( bot_bot @ A ) )
            & ( B3
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_bot.neutr_eq_iff
thf(fact_12_sup__bot_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A2: A] :
          ( ( sup_sup @ A @ A2 @ ( bot_bot @ A ) )
          = A2 ) ) ).

% sup_bot.right_neutral
thf(fact_13_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X2: A] :
            ~ ( P @ X2 ) ) ) ).

% empty_Collect_eq
thf(fact_14_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X2: A] :
            ~ ( P @ X2 ) ) ) ).

% Collect_empty_eq
thf(fact_15_all__not__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ! [X2: A] :
            ~ ( member @ A @ X2 @ A3 ) )
      = ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_16_empty__iff,axiom,
    ! [A: $tType,C2: A] :
      ~ ( member @ A @ C2 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_17_insert__absorb2,axiom,
    ! [A: $tType,X: A,A3: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ X @ A3 ) )
      = ( insert @ A @ X @ A3 ) ) ).

% insert_absorb2
thf(fact_18_insert__iff,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A3 ) )
      = ( ( A2 = B3 )
        | ( member @ A @ A2 @ A3 ) ) ) ).

% insert_iff
thf(fact_19_insertCI,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( ~ ( member @ A @ A2 @ B2 )
       => ( A2 = B3 ) )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertCI
thf(fact_20_sup_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [A2: A,B3: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A2 @ B3 ) @ B3 )
          = ( sup_sup @ A @ A2 @ B3 ) ) ) ).

% sup.right_idem
thf(fact_21_sup__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [X: A,Y: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ X @ Y ) )
          = ( sup_sup @ A @ X @ Y ) ) ) ).

% sup_left_idem
thf(fact_22_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [A2: A,B3: A] :
          ( ( sup_sup @ A @ A2 @ ( sup_sup @ A @ A2 @ B3 ) )
          = ( sup_sup @ A @ A2 @ B3 ) ) ) ).

% sup.left_idem
thf(fact_23_sup__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ X )
          = X ) ) ).

% sup_idem
thf(fact_24_sup_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [A2: A] :
          ( ( sup_sup @ A @ A2 @ A2 )
          = A2 ) ) ).

% sup.idem
thf(fact_25_sup__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X2: A] : ( sup_sup @ B @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ) ).

% sup_apply
thf(fact_26_UnCI,axiom,
    ! [A: $tType,C2: A,B2: set @ A,A3: set @ A] :
      ( ( ~ ( member @ A @ C2 @ B2 )
       => ( member @ A @ C2 @ A3 ) )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) ) ) ).

% UnCI
thf(fact_27_singletonI,axiom,
    ! [A: $tType,A2: A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_28_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_29_ex__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ? [X2: A] : ( member @ A @ X2 @ A3 ) )
      = ( A3
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_30_equals0I,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ! [Y2: A] :
          ~ ( member @ A @ Y2 @ A3 )
     => ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_31_equals0D,axiom,
    ! [A: $tType,A3: set @ A,A2: A] :
      ( ( A3
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A2 @ A3 ) ) ).

% equals0D
thf(fact_32_emptyE,axiom,
    ! [A: $tType,A2: A] :
      ~ ( member @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_33_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ? [B4: set @ A] :
          ( ( A3
            = ( insert @ A @ A2 @ B4 ) )
          & ~ ( member @ A @ A2 @ B4 ) ) ) ).

% mk_disjoint_insert
thf(fact_34_insert__commute,axiom,
    ! [A: $tType,X: A,Y: A,A3: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ Y @ A3 ) )
      = ( insert @ A @ Y @ ( insert @ A @ X @ A3 ) ) ) ).

% insert_commute
thf(fact_35_insert__eq__iff,axiom,
    ! [A: $tType,A2: A,A3: set @ A,B3: A,B2: set @ A] :
      ( ~ ( member @ A @ A2 @ A3 )
     => ( ~ ( member @ A @ B3 @ B2 )
       => ( ( ( insert @ A @ A2 @ A3 )
            = ( insert @ A @ B3 @ B2 ) )
          = ( ( ( A2 = B3 )
             => ( A3 = B2 ) )
            & ( ( A2 != B3 )
             => ? [C3: set @ A] :
                  ( ( A3
                    = ( insert @ A @ B3 @ C3 ) )
                  & ~ ( member @ A @ B3 @ C3 )
                  & ( B2
                    = ( insert @ A @ A2 @ C3 ) )
                  & ~ ( member @ A @ A2 @ C3 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_36_insert__absorb,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ( ( insert @ A @ A2 @ A3 )
        = A3 ) ) ).

% insert_absorb
thf(fact_37_insert__ident,axiom,
    ! [A: $tType,X: A,A3: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X @ A3 )
     => ( ~ ( member @ A @ X @ B2 )
       => ( ( ( insert @ A @ X @ A3 )
            = ( insert @ A @ X @ B2 ) )
          = ( A3 = B2 ) ) ) ) ).

% insert_ident
thf(fact_38_Set_Oset__insert,axiom,
    ! [A: $tType,X: A,A3: set @ A] :
      ( ( member @ A @ X @ A3 )
     => ~ ! [B4: set @ A] :
            ( ( A3
              = ( insert @ A @ X @ B4 ) )
           => ( member @ A @ X @ B4 ) ) ) ).

% Set.set_insert
thf(fact_39_insertI2,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( member @ A @ A2 @ B2 )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertI2
thf(fact_40_insertI1,axiom,
    ! [A: $tType,A2: A,B2: set @ A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ B2 ) ) ).

% insertI1
thf(fact_41_insertE,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A3 ) )
     => ( ( A2 != B3 )
       => ( member @ A @ A2 @ A3 ) ) ) ).

% insertE
thf(fact_42_sup__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ Y @ ( sup_sup @ A @ X @ Z ) ) ) ) ).

% sup_left_commute
thf(fact_43_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [B3: A,A2: A,C2: A] :
          ( ( sup_sup @ A @ B3 @ ( sup_sup @ A @ A2 @ C2 ) )
          = ( sup_sup @ A @ A2 @ ( sup_sup @ A @ B3 @ C2 ) ) ) ) ).

% sup.left_commute
thf(fact_44_sup__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ( ( sup_sup @ A )
        = ( ^ [X2: A,Y3: A] : ( sup_sup @ A @ Y3 @ X2 ) ) ) ) ).

% sup_commute
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G2: A > B] :
      ( ! [X3: A] :
          ( ( F2 @ X3 )
          = ( G2 @ X3 ) )
     => ( F2 = G2 ) ) ).

% ext
thf(fact_49_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ( ( sup_sup @ A )
        = ( ^ [A4: A,B5: A] : ( sup_sup @ A @ B5 @ A4 ) ) ) ) ).

% sup.commute
thf(fact_50_sup__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ Y ) @ Z )
          = ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) ) ) ) ).

% sup_assoc
thf(fact_51_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [A2: A,B3: A,C2: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A2 @ B3 ) @ C2 )
          = ( sup_sup @ A @ A2 @ ( sup_sup @ A @ B3 @ C2 ) ) ) ) ).

% sup.assoc
thf(fact_52_boolean__algebra__cancel_Osup2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [B2: A,K: A,B3: A,A2: A] :
          ( ( B2
            = ( sup_sup @ A @ K @ B3 ) )
         => ( ( sup_sup @ A @ A2 @ B2 )
            = ( sup_sup @ A @ K @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ) ).

% boolean_algebra_cancel.sup2
thf(fact_53_boolean__algebra__cancel_Osup1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [A3: A,K: A,A2: A,B3: A] :
          ( ( A3
            = ( sup_sup @ A @ K @ A2 ) )
         => ( ( sup_sup @ A @ A3 @ B3 )
            = ( sup_sup @ A @ K @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ) ).

% boolean_algebra_cancel.sup1
thf(fact_54_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X2: A] : ( sup_sup @ B @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ) ).

% sup_fun_def
thf(fact_55_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A )
     => ( ( sup_sup @ A )
        = ( ^ [X2: A,Y3: A] : ( sup_sup @ A @ Y3 @ X2 ) ) ) ) ).

% inf_sup_aci(5)
thf(fact_56_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ Y ) @ Z )
          = ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(6)
thf(fact_57_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ Y @ ( sup_sup @ A @ X @ Z ) ) ) ) ).

% inf_sup_aci(7)
thf(fact_58_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A )
     => ! [X: A,Y: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ X @ Y ) )
          = ( sup_sup @ A @ X @ Y ) ) ) ).

% inf_sup_aci(8)
thf(fact_59_Un__left__commute,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A,C: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A3 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) )
      = ( sup_sup @ ( set @ A ) @ B2 @ ( sup_sup @ ( set @ A ) @ A3 @ C ) ) ) ).

% Un_left_commute
thf(fact_60_Un__left__absorb,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A3 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) )
      = ( sup_sup @ ( set @ A ) @ A3 @ B2 ) ) ).

% Un_left_absorb
thf(fact_61_Un__commute,axiom,
    ! [A: $tType] :
      ( ( sup_sup @ ( set @ A ) )
      = ( ^ [A5: set @ A,B6: set @ A] : ( sup_sup @ ( set @ A ) @ B6 @ A5 ) ) ) ).

% Un_commute
thf(fact_62_Un__absorb,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A3 @ A3 )
      = A3 ) ).

% Un_absorb
thf(fact_63_Un__assoc,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A,C: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) @ C )
      = ( sup_sup @ ( set @ A ) @ A3 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) ) ) ).

% Un_assoc
thf(fact_64_ball__Un,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A,P: A > $o] :
      ( ( ! [X2: A] :
            ( ( member @ A @ X2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) )
           => ( P @ X2 ) ) )
      = ( ! [X2: A] :
            ( ( member @ A @ X2 @ A3 )
           => ( P @ X2 ) )
        & ! [X2: A] :
            ( ( member @ A @ X2 @ B2 )
           => ( P @ X2 ) ) ) ) ).

% ball_Un
thf(fact_65_bex__Un,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member @ A @ X2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) )
            & ( P @ X2 ) ) )
      = ( ? [X2: A] :
            ( ( member @ A @ X2 @ A3 )
            & ( P @ X2 ) )
        | ? [X2: A] :
            ( ( member @ A @ X2 @ B2 )
            & ( P @ X2 ) ) ) ) ).

% bex_Un
thf(fact_66_UnI2,axiom,
    ! [A: $tType,C2: A,B2: set @ A,A3: set @ A] :
      ( ( member @ A @ C2 @ B2 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) ) ) ).

% UnI2
thf(fact_67_UnI1,axiom,
    ! [A: $tType,C2: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ A3 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) ) ) ).

% UnI1
thf(fact_68_UnE,axiom,
    ! [A: $tType,C2: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) )
     => ( ~ ( member @ A @ C2 @ A3 )
       => ( member @ A @ C2 @ B2 ) ) ) ).

% UnE
thf(fact_69_Uvariation__sym__rel,axiom,
    ! [Omega: variable > real,Nu: variable > real,U: set @ variable] :
      ( ( denota1419872369iation @ Omega @ Nu @ U )
     => ( denota1419872369iation @ Nu @ Omega @ U ) ) ).

% Uvariation_sym_rel
thf(fact_70_Uvariation__refl,axiom,
    ! [Nu: variable > real,V: set @ variable] : ( denota1419872369iation @ Nu @ Nu @ V ) ).

% Uvariation_refl
thf(fact_71_Uvariation__sym,axiom,
    ( denota1419872369iation
    = ( ^ [Omega2: variable > real,Nu3: variable > real] : ( denota1419872369iation @ Nu3 @ Omega2 ) ) ) ).

% Uvariation_sym
thf(fact_72_Uvariation__def,axiom,
    ( denota1419872369iation
    = ( ^ [Nu3: variable > real,Nu4: variable > real,U2: set @ variable] :
        ! [I: variable] :
          ( ~ ( member @ variable @ I @ U2 )
         => ( ( Nu3 @ I )
            = ( Nu4 @ I ) ) ) ) ) ).

% Uvariation_def
thf(fact_73_singleton__inject,axiom,
    ! [A: $tType,A2: A,B3: A] :
      ( ( ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A2 = B3 ) ) ).

% singleton_inject
thf(fact_74_insert__not__empty,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( insert @ A @ A2 @ A3 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_75_doubleton__eq__iff,axiom,
    ! [A: $tType,A2: A,B3: A,C2: A,D: A] :
      ( ( ( insert @ A @ A2 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C2 @ ( insert @ A @ D @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A2 = C2 )
          & ( B3 = D ) )
        | ( ( A2 = D )
          & ( B3 = C2 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_76_singleton__iff,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B3 = A2 ) ) ).

% singleton_iff
thf(fact_77_singletonD,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B3 = A2 ) ) ).

% singletonD
thf(fact_78_Un__empty__right,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A3 @ ( bot_bot @ ( set @ A ) ) )
      = A3 ) ).

% Un_empty_right
thf(fact_79_Un__empty__left,axiom,
    ! [A: $tType,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ B2 )
      = B2 ) ).

% Un_empty_left
thf(fact_80_Uvariation__trans,axiom,
    ! [Omega: variable > real,Nu: variable > real,U: set @ variable,Mu: variable > real,V: set @ variable] :
      ( ( denota1419872369iation @ Omega @ Nu @ U )
     => ( ( denota1419872369iation @ Nu @ Mu @ V )
       => ( denota1419872369iation @ Omega @ Mu @ ( sup_sup @ ( set @ variable ) @ U @ V ) ) ) ) ).

% Uvariation_trans
thf(fact_81_singleton__Un__iff,axiom,
    ! [A: $tType,X: A,A3: set @ A,B2: set @ A] :
      ( ( ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) )
        = ( sup_sup @ ( set @ A ) @ A3 @ B2 ) )
      = ( ( ( A3
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A3
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A3
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% singleton_Un_iff
thf(fact_82_Un__singleton__iff,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A,X: A] :
      ( ( ( sup_sup @ ( set @ A ) @ A3 @ B2 )
        = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( ( A3
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A3
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A3
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% Un_singleton_iff
thf(fact_83_insert__is__Un,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A4: A] : ( sup_sup @ ( set @ A ) @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% insert_is_Un
thf(fact_84__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062rr_O_A_092_060forall_062x0_Ax1_Ax2_Ax3_Ax4_Ax5_O_A_I_092_060exists_062v6_O_AUvariation_Av6_A_Ix5_A0_J_A_123RVar_Ax4_M_ADVar_Ax4_125_A_092_060and_062_Aterm__sem_Ax3_Ax2_Av6_A_092_060noteq_062_Aterm__sem_Ax1_Ax0_Av6_J_A_061_A_IUvariation_A_Irr_Ax0_Ax1_Ax2_Ax3_Ax4_Ax5_J_A_Ix5_A0_J_A_123RVar_Ax4_M_ADVar_Ax4_125_A_092_060and_062_Aterm__sem_Ax3_Ax2_A_Irr_Ax0_Ax1_Ax2_Ax3_Ax4_Ax5_J_A_092_060noteq_062_Aterm__sem_Ax1_Ax0_A_Irr_Ax0_Ax1_Ax2_Ax3_Ax4_Ax5_J_J_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [Rr: trm > denotational_interp > trm > denotational_interp > char > ( real > variable > real ) > variable > real] :
        ~ ! [X0: trm,X1: denotational_interp,X22: trm,X32: denotational_interp,X4: char,X5: real > variable > real] :
            ( ( ? [V6: variable > real] :
                  ( ( denota1419872369iation @ V6 @ ( X5 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ X4 ) @ ( insert @ variable @ ( dVar @ X4 ) @ ( bot_bot @ ( set @ variable ) ) ) ) )
                  & ( ( denota1863255036rm_sem @ X32 @ X22 @ V6 )
                   != ( denota1863255036rm_sem @ X1 @ X0 @ V6 ) ) ) )
            = ( ( denota1419872369iation @ ( Rr @ X0 @ X1 @ X22 @ X32 @ X4 @ X5 ) @ ( X5 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ X4 ) @ ( insert @ variable @ ( dVar @ X4 ) @ ( bot_bot @ ( set @ variable ) ) ) ) )
              & ( ( denota1863255036rm_sem @ X32 @ X22 @ ( Rr @ X0 @ X1 @ X22 @ X32 @ X4 @ X5 ) )
               != ( denota1863255036rm_sem @ X1 @ X0 @ ( Rr @ X0 @ X1 @ X22 @ X32 @ X4 @ X5 ) ) ) ) ) ).

% \<open>\<And>thesis. (\<And>rr. \<forall>x0 x1 x2 x3 x4 x5. (\<exists>v6. Uvariation v6 (x5 0) {RVar x4, DVar x4} \<and> term_sem x3 x2 v6 \<noteq> term_sem x1 x0 v6) = (Uvariation (rr x0 x1 x2 x3 x4 x5) (x5 0) {RVar x4, DVar x4} \<and> term_sem x3 x2 (rr x0 x1 x2 x3 x4 x5) \<noteq> term_sem x1 x0 (rr x0 x1 x2 x3 x4 x5)) \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_85_solves__Vagree__trans,axiom,
    ! [F3: real > variable > real,Omega: variable > real,U: set @ variable,I2: denotational_interp,X: char,Theta: trm,Zeta: real] :
      ( ( denota1419872369iation @ ( F3 @ ( zero_zero @ real ) ) @ Omega @ U )
     => ( ( denota1778088425es_ODE @ I2 @ F3 @ X @ Theta )
       => ( denota1419872369iation @ ( F3 @ Zeta ) @ Omega @ ( sup_sup @ ( set @ variable ) @ U @ ( insert @ variable @ ( rVar @ X ) @ ( insert @ variable @ ( dVar @ X ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) ) ) ) ).

% solves_Vagree_trans
thf(fact_86__092_060open_062_092_060forall_062x0_Ax1_Ax2_Ax3_Ax4_Ax5_O_A_I_092_060exists_062v6_O_AUvariation_Av6_A_Ix5_A0_J_A_123RVar_Ax4_M_ADVar_Ax4_125_A_092_060and_062_Aterm__sem_Ax3_Ax2_Av6_A_092_060noteq_062_Aterm__sem_Ax1_Ax0_Av6_J_A_061_A_IUvariation_A_Irr_Ax0_Ax1_Ax2_Ax3_Ax4_Ax5_J_A_Ix5_A0_J_A_123RVar_Ax4_M_ADVar_Ax4_125_A_092_060and_062_Aterm__sem_Ax3_Ax2_A_Irr_Ax0_Ax1_Ax2_Ax3_Ax4_Ax5_J_A_092_060noteq_062_Aterm__sem_Ax1_Ax0_A_Irr_Ax0_Ax1_Ax2_Ax3_Ax4_Ax5_J_J_092_060close_062,axiom,
    ! [X0: trm,X1: denotational_interp,X22: trm,X32: denotational_interp,X4: char,X5: real > variable > real] :
      ( ( ? [V6: variable > real] :
            ( ( denota1419872369iation @ V6 @ ( X5 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ X4 ) @ ( insert @ variable @ ( dVar @ X4 ) @ ( bot_bot @ ( set @ variable ) ) ) ) )
            & ( ( denota1863255036rm_sem @ X32 @ X22 @ V6 )
             != ( denota1863255036rm_sem @ X1 @ X0 @ V6 ) ) ) )
      = ( ( denota1419872369iation @ ( rr @ X0 @ X1 @ X22 @ X32 @ X4 @ X5 ) @ ( X5 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ X4 ) @ ( insert @ variable @ ( dVar @ X4 ) @ ( bot_bot @ ( set @ variable ) ) ) ) )
        & ( ( denota1863255036rm_sem @ X32 @ X22 @ ( rr @ X0 @ X1 @ X22 @ X32 @ X4 @ X5 ) )
         != ( denota1863255036rm_sem @ X1 @ X0 @ ( rr @ X0 @ X1 @ X22 @ X32 @ X4 @ X5 ) ) ) ) ) ).

% \<open>\<forall>x0 x1 x2 x3 x4 x5. (\<exists>v6. Uvariation v6 (x5 0) {RVar x4, DVar x4} \<and> term_sem x3 x2 v6 \<noteq> term_sem x1 x0 v6) = (Uvariation (rr x0 x1 x2 x3 x4 x5) (x5 0) {RVar x4, DVar x4} \<and> term_sem x3 x2 (rr x0 x1 x2 x3 x4 x5) \<noteq> term_sem x1 x0 (rr x0 x1 x2 x3 x4 x5))\<close>
thf(fact_87_variable_Oinject_I1_J,axiom,
    ! [X12: char,Y1: char] :
      ( ( ( rVar @ X12 )
        = ( rVar @ Y1 ) )
      = ( X12 = Y1 ) ) ).

% variable.inject(1)
thf(fact_88_set__zero,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( zero_zero @ ( set @ A ) )
        = ( insert @ A @ ( zero_zero @ A ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% set_zero
thf(fact_89_variable_Oinject_I2_J,axiom,
    ! [X23: char,Y22: char] :
      ( ( ( dVar @ X23 )
        = ( dVar @ Y22 ) )
      = ( X23 = Y22 ) ) ).

% variable.inject(2)
thf(fact_90_union__or,axiom,
    ! [A: $tType,C2: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) )
      = ( ( member @ A @ C2 @ A3 )
        | ( member @ A @ C2 @ B2 ) ) ) ).

% union_or
thf(fact_91_ball__insert,axiom,
    ! [A: $tType,A2: A,B2: set @ A,P: A > $o] :
      ( ( ! [X2: A] :
            ( ( member @ A @ X2 @ ( insert @ A @ A2 @ B2 ) )
           => ( P @ X2 ) ) )
      = ( ( P @ A2 )
        & ! [X2: A] :
            ( ( member @ A @ X2 @ B2 )
           => ( P @ X2 ) ) ) ) ).

% ball_insert
thf(fact_92_the__elem__eq,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = X ) ).

% the_elem_eq
thf(fact_93_bot__apply,axiom,
    ! [C4: $tType,D2: $tType] :
      ( ( bot @ C4 )
     => ( ( bot_bot @ ( D2 > C4 ) )
        = ( ^ [X2: D2] : ( bot_bot @ C4 ) ) ) ) ).

% bot_apply
thf(fact_94_f2,axiom,
    ! [F4: real > variable > real,C5: char,I3: denotational_interp,T: trm,Ia: denotational_interp,Ta: trm] :
      ( ( ( denota1419872369iation @ ( rr @ Ta @ Ia @ T @ I3 @ C5 @ F4 ) @ ( F4 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ C5 ) @ ( insert @ variable @ ( dVar @ C5 ) @ ( bot_bot @ ( set @ variable ) ) ) ) )
        & ( ( denota1863255036rm_sem @ I3 @ T @ ( rr @ Ta @ Ia @ T @ I3 @ C5 @ F4 ) )
         != ( denota1863255036rm_sem @ Ia @ Ta @ ( rr @ Ta @ Ia @ T @ I3 @ C5 @ F4 ) ) ) )
      | ( ( denota1778088425es_ODE @ I3 @ F4 @ C5 @ T )
        = ( denota1778088425es_ODE @ Ia @ F4 @ C5 @ Ta ) ) ) ).

% f2
thf(fact_95_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_96_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X2: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_97_not__union__or,axiom,
    ! [A: $tType,X: A,A3: set @ A,B2: set @ A] :
      ( ( ~ ( member @ A @ X @ ( sup_sup @ ( set @ A ) @ A3 @ B2 ) ) )
      = ( ~ ( member @ A @ X @ A3 )
        & ~ ( member @ A @ X @ B2 ) ) ) ).

% not_union_or
thf(fact_98_same__ODE__same__sol,axiom,
    ! [F3: real > variable > real,X: char,I2: denotational_interp,Theta: trm,J: denotational_interp,Eta: trm] :
      ( ! [Nu5: variable > real] :
          ( ( denota1419872369iation @ Nu5 @ ( F3 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ X ) @ ( insert @ variable @ ( dVar @ X ) @ ( bot_bot @ ( set @ variable ) ) ) ) )
         => ( ( denota1863255036rm_sem @ I2 @ Theta @ Nu5 )
            = ( denota1863255036rm_sem @ J @ Eta @ Nu5 ) ) )
     => ( ( denota1778088425es_ODE @ I2 @ F3 @ X @ Theta )
        = ( denota1778088425es_ODE @ J @ F3 @ X @ Eta ) ) ) ).

% same_ODE_same_sol
thf(fact_99_variable_Odistinct_I1_J,axiom,
    ! [X12: char,X23: char] :
      ( ( rVar @ X12 )
     != ( dVar @ X23 ) ) ).

% variable.distinct(1)
thf(fact_100_variable_Oinduct,axiom,
    ! [P: variable > $o,Variable: variable] :
      ( ! [X3: char] : ( P @ ( rVar @ X3 ) )
     => ( ! [X3: char] : ( P @ ( dVar @ X3 ) )
       => ( P @ Variable ) ) ) ).

% variable.induct
thf(fact_101_variable_Oexhaust,axiom,
    ! [Y: variable] :
      ( ! [X13: char] :
          ( Y
         != ( rVar @ X13 ) )
     => ~ ! [X24: char] :
            ( Y
           != ( dVar @ X24 ) ) ) ).

% variable.exhaust
thf(fact_102_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X2: A] : ( member @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_103_Collect__empty__eq__bot,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( P
        = ( bot_bot @ ( A > $o ) ) ) ) ).

% Collect_empty_eq_bot
thf(fact_104_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A5: set @ A] :
            ( A5
            = ( insert @ A @ ( the_elem @ A @ A5 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_105_vaflow2,axiom,
    ! [F3: real > variable > real,Theta: trm,Zeta: real] :
      ( ( denota1778088425es_ODE @ ( uSubst2091380086djoint @ sigma @ i @ omega ) @ F3 @ x @ Theta )
     => ( denota1419872369iation @ ( F3 @ Zeta ) @ ( F3 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) ) ).

% vaflow2
thf(fact_106_is__singletonI,axiom,
    ! [A: $tType,X: A] : ( is_singleton @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_107_a1,axiom,
    denota1778088425es_ODE @ ( uSubst2091380086djoint @ sigma @ i @ omega ) @ f @ x @ theta ).

% a1
thf(fact_108_is__singletonI_H,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( A3
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X3: A,Y2: A] :
            ( ( member @ A @ X3 @ A3 )
           => ( ( member @ A @ Y2 @ A3 )
             => ( X3 = Y2 ) ) )
       => ( is_singleton @ A @ A3 ) ) ) ).

% is_singletonI'
thf(fact_109_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A5: set @ A] :
          ? [X2: A] :
            ( A5
            = ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_110_is__singletonE,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( is_singleton @ A @ A3 )
     => ~ ! [X3: A] :
            ( A3
           != ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_111_vaflow1,axiom,
    ! [F3: real > variable > real,Theta: trm,Zeta: real] :
      ( ( denota1778088425es_ODE @ i @ F3 @ x @ ( the @ trm @ ( uSubst95898992stappt @ sigma @ ( sup_sup @ ( set @ variable ) @ u @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) @ Theta ) ) )
     => ( denota1419872369iation @ ( F3 @ Zeta ) @ ( F3 @ ( zero_zero @ real ) ) @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) ) ).

% vaflow1
thf(fact_112_l2r,axiom,
    ( ( denota1778088425es_ODE @ i @ f @ x @ ( the @ trm @ ( uSubst95898992stappt @ sigma @ ( sup_sup @ ( set @ variable ) @ u @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) @ theta ) ) )
   => ( denota1778088425es_ODE @ ( uSubst2091380086djoint @ sigma @ i @ omega ) @ f @ x @ theta ) ) ).

% l2r
thf(fact_113_IH,axiom,
    ! [Nu: variable > real] :
      ( ( denota1419872369iation @ Nu @ ( f @ ( zero_zero @ real ) ) @ ( sup_sup @ ( set @ variable ) @ u @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) )
     => ( ( denota1863255036rm_sem @ i @ ( the @ trm @ ( uSubst95898992stappt @ sigma @ ( sup_sup @ ( set @ variable ) @ u @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) @ theta ) ) @ Nu )
        = ( denota1863255036rm_sem @ ( uSubst2091380086djoint @ sigma @ i @ ( f @ ( zero_zero @ real ) ) ) @ theta @ Nu ) ) ) ).

% IH
thf(fact_114_subdef,axiom,
    ( ( uSubst95898992stappt @ sigma @ ( sup_sup @ ( set @ variable ) @ u @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) @ theta )
   != ( none @ trm ) ) ).

% subdef
thf(fact_115_variable_Osize__gen_I1_J,axiom,
    ! [X12: char] :
      ( ( size_variable @ ( rVar @ X12 ) )
      = ( zero_zero @ nat ) ) ).

% variable.size_gen(1)
thf(fact_116_usubst__term,axiom,
    ! [Nu: variable > real,Omega: variable > real,U: set @ variable,Sigma: product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ),Theta: trm,I2: denotational_interp] :
      ( ( denota1419872369iation @ Nu @ Omega @ U )
     => ( ( ( uSubst95898992stappt @ Sigma @ U @ Theta )
         != ( none @ trm ) )
       => ( ( denota1863255036rm_sem @ I2 @ ( the @ trm @ ( uSubst95898992stappt @ Sigma @ U @ Theta ) ) @ Nu )
          = ( denota1863255036rm_sem @ ( uSubst2091380086djoint @ Sigma @ I2 @ Omega ) @ Theta @ Nu ) ) ) ) ).

% usubst_term
thf(fact_117_usubstappt__det,axiom,
    ! [Sigma: product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ),U: set @ variable,Theta: trm,V: set @ variable] :
      ( ( ( uSubst95898992stappt @ Sigma @ U @ Theta )
       != ( none @ trm ) )
     => ( ( ( uSubst95898992stappt @ Sigma @ V @ Theta )
         != ( none @ trm ) )
       => ( ( uSubst95898992stappt @ Sigma @ U @ Theta )
          = ( uSubst95898992stappt @ Sigma @ V @ Theta ) ) ) ) ).

% usubstappt_det
thf(fact_118_undeft__None,axiom,
    ( ( none @ trm )
    = ( none @ trm ) ) ).

% undeft_None
thf(fact_119_usubst__ode,axiom,
    ! [Sigma: product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ),X: char,Theta: trm,I2: denotational_interp,F3: real > variable > real] :
      ( ( ( uSubst95898992stappt @ Sigma @ ( insert @ variable @ ( rVar @ X ) @ ( insert @ variable @ ( dVar @ X ) @ ( bot_bot @ ( set @ variable ) ) ) ) @ Theta )
       != ( none @ trm ) )
     => ( ( denota1778088425es_ODE @ I2 @ F3 @ X @ ( the @ trm @ ( uSubst95898992stappt @ Sigma @ ( insert @ variable @ ( rVar @ X ) @ ( insert @ variable @ ( dVar @ X ) @ ( bot_bot @ ( set @ variable ) ) ) ) @ Theta ) ) )
        = ( denota1778088425es_ODE @ ( uSubst2091380086djoint @ Sigma @ I2 @ ( F3 @ ( zero_zero @ real ) ) ) @ F3 @ X @ Theta ) ) ) ).

% usubst_ode
thf(fact_120_variable_Osize__gen_I2_J,axiom,
    ! [X23: char] :
      ( ( size_variable @ ( dVar @ X23 ) )
      = ( zero_zero @ nat ) ) ).

% variable.size_gen(2)
thf(fact_121_option_Oexpand,axiom,
    ! [A: $tType,Option: option @ A,Option2: option @ A] :
      ( ( ( Option
          = ( none @ A ) )
        = ( Option2
          = ( none @ A ) ) )
     => ( ( ( Option
           != ( none @ A ) )
         => ( ( Option2
             != ( none @ A ) )
           => ( ( the @ A @ Option )
              = ( the @ A @ Option2 ) ) ) )
       => ( Option = Option2 ) ) ) ).

% option.expand
thf(fact_122_variable_Osize_I3_J,axiom,
    ! [X12: char] :
      ( ( size_size @ variable @ ( rVar @ X12 ) )
      = ( zero_zero @ nat ) ) ).

% variable.size(3)
thf(fact_123_variable_Osize_I4_J,axiom,
    ! [X23: char] :
      ( ( size_size @ variable @ ( dVar @ X23 ) )
      = ( zero_zero @ nat ) ) ).

% variable.size(4)
thf(fact_124_Set_Ois__empty__def,axiom,
    ! [A: $tType] :
      ( ( is_empty @ A )
      = ( ^ [A5: set @ A] :
            ( A5
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Set.is_empty_def
thf(fact_125_Uvariation__repv,axiom,
    ! [Omega: variable > real,X: variable,D: real] : ( denota1419872369iation @ Omega @ ( denotational_repv @ Omega @ X @ D ) @ ( insert @ variable @ X @ ( bot_bot @ ( set @ variable ) ) ) ) ).

% Uvariation_repv
thf(fact_126_these__empty__eq,axiom,
    ! [A: $tType,B2: set @ ( option @ A )] :
      ( ( ( these @ A @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ( B2
          = ( bot_bot @ ( set @ ( option @ A ) ) ) )
        | ( B2
          = ( insert @ ( option @ A ) @ ( none @ A ) @ ( bot_bot @ ( set @ ( option @ A ) ) ) ) ) ) ) ).

% these_empty_eq
thf(fact_127_these__not__empty__eq,axiom,
    ! [A: $tType,B2: set @ ( option @ A )] :
      ( ( ( these @ A @ B2 )
       != ( bot_bot @ ( set @ A ) ) )
      = ( ( B2
         != ( bot_bot @ ( set @ ( option @ A ) ) ) )
        & ( B2
         != ( insert @ ( option @ A ) @ ( none @ A ) @ ( bot_bot @ ( set @ ( option @ A ) ) ) ) ) ) ) ).

% these_not_empty_eq
thf(fact_128_variable_Osimps_I7_J,axiom,
    ! [A: $tType,F1: char > A,F22: char > A,X12: char] :
      ( ( rec_variable @ A @ F1 @ F22 @ ( rVar @ X12 ) )
      = ( F1 @ X12 ) ) ).

% variable.simps(7)
thf(fact_129_repv__self,axiom,
    ! [Omega: variable > real,X: variable] :
      ( ( denotational_repv @ Omega @ X @ ( Omega @ X ) )
      = Omega ) ).

% repv_self
thf(fact_130_repv__access,axiom,
    ( denotational_repv
    = ( ^ [Omega2: variable > real,X2: variable,R: real,Y3: variable] : ( if @ real @ ( X2 = Y3 ) @ R @ ( Omega2 @ Y3 ) ) ) ) ).

% repv_access
thf(fact_131_these__empty,axiom,
    ! [A: $tType] :
      ( ( these @ A @ ( bot_bot @ ( set @ ( option @ A ) ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% these_empty
thf(fact_132_these__insert__None,axiom,
    ! [A: $tType,A3: set @ ( option @ A )] :
      ( ( these @ A @ ( insert @ ( option @ A ) @ ( none @ A ) @ A3 ) )
      = ( these @ A @ A3 ) ) ).

% these_insert_None
thf(fact_133_repv__def__correct,axiom,
    ( denotational_repv
    = ( ^ [Omega2: variable > real,X2: variable,R: real,Y3: variable] : ( if @ real @ ( X2 = Y3 ) @ R @ ( Omega2 @ Y3 ) ) ) ) ).

% repv_def_correct
thf(fact_134_variable_Osimps_I8_J,axiom,
    ! [A: $tType,F1: char > A,F22: char > A,X23: char] :
      ( ( rec_variable @ A @ F1 @ F22 @ ( dVar @ X23 ) )
      = ( F22 @ X23 ) ) ).

% variable.simps(8)
thf(fact_135_these__insert__Some,axiom,
    ! [A: $tType,X: A,A3: set @ ( option @ A )] :
      ( ( these @ A @ ( insert @ ( option @ A ) @ ( some @ A @ X ) @ A3 ) )
      = ( insert @ A @ X @ ( these @ A @ A3 ) ) ) ).

% these_insert_Some
thf(fact_136_repv__selectlike__other__converse,axiom,
    ! [X: variable,Y: variable,Omega: variable > real,D: real,X6: set @ ( variable > real )] :
      ( ( X != Y )
     => ( ( member @ ( variable > real ) @ ( denotational_repv @ Omega @ X @ D ) @ X6 )
        = ( member @ ( variable > real ) @ ( denotational_repv @ Omega @ X @ D ) @ ( static_selectlike @ X6 @ Omega @ ( insert @ variable @ Y @ ( bot_bot @ ( set @ variable ) ) ) ) ) ) ) ).

% repv_selectlike_other_converse
thf(fact_137_repv__selectlike__other,axiom,
    ! [X: variable,Y: variable,Omega: variable > real,D: real,X6: set @ ( variable > real )] :
      ( ( X != Y )
     => ( ( member @ ( variable > real ) @ ( denotational_repv @ Omega @ X @ D ) @ ( static_selectlike @ X6 @ Omega @ ( insert @ variable @ Y @ ( bot_bot @ ( set @ variable ) ) ) ) )
        = ( member @ ( variable > real ) @ ( denotational_repv @ Omega @ X @ D ) @ X6 ) ) ) ).

% repv_selectlike_other
thf(fact_138_repv__selectlike__self,axiom,
    ! [Omega: variable > real,X: variable,D: real,X6: set @ ( variable > real )] :
      ( ( member @ ( variable > real ) @ ( denotational_repv @ Omega @ X @ D ) @ ( static_selectlike @ X6 @ Omega @ ( insert @ variable @ X @ ( bot_bot @ ( set @ variable ) ) ) ) )
      = ( ( D
          = ( Omega @ X ) )
        & ( member @ ( variable > real ) @ Omega @ X6 ) ) ) ).

% repv_selectlike_self
thf(fact_139_option_Oinject,axiom,
    ! [A: $tType,X23: A,Y22: A] :
      ( ( ( some @ A @ X23 )
        = ( some @ A @ Y22 ) )
      = ( X23 = Y22 ) ) ).

% option.inject
thf(fact_140_selectlike__self,axiom,
    ! [Nu: variable > real,X6: set @ ( variable > real ),V: set @ variable] :
      ( ( member @ ( variable > real ) @ Nu @ ( static_selectlike @ X6 @ Nu @ V ) )
      = ( member @ ( variable > real ) @ Nu @ X6 ) ) ).

% selectlike_self
thf(fact_141_not__None__eq,axiom,
    ! [A: $tType,X: option @ A] :
      ( ( X
       != ( none @ A ) )
      = ( ? [Y3: A] :
            ( X
            = ( some @ A @ Y3 ) ) ) ) ).

% not_None_eq
thf(fact_142_not__Some__eq,axiom,
    ! [A: $tType,X: option @ A] :
      ( ( ! [Y3: A] :
            ( X
           != ( some @ A @ Y3 ) ) )
      = ( X
        = ( none @ A ) ) ) ).

% not_Some_eq
thf(fact_143_selectlike__empty,axiom,
    ! [X6: set @ ( variable > real ),Nu: variable > real] :
      ( ( static_selectlike @ X6 @ Nu @ ( bot_bot @ ( set @ variable ) ) )
      = X6 ) ).

% selectlike_empty
thf(fact_144_selectlike__compose,axiom,
    ! [X6: set @ ( variable > real ),Nu: variable > real,V: set @ variable,W: set @ variable] :
      ( ( static_selectlike @ ( static_selectlike @ X6 @ Nu @ V ) @ Nu @ W )
      = ( static_selectlike @ X6 @ Nu @ ( sup_sup @ ( set @ variable ) @ V @ W ) ) ) ).

% selectlike_compose
thf(fact_145_option_Ocollapse,axiom,
    ! [A: $tType,Option: option @ A] :
      ( ( Option
       != ( none @ A ) )
     => ( ( some @ A @ ( the @ A @ Option ) )
        = Option ) ) ).

% option.collapse
thf(fact_146_in__these__eq,axiom,
    ! [A: $tType,X: A,A3: set @ ( option @ A )] :
      ( ( member @ A @ X @ ( these @ A @ A3 ) )
      = ( member @ ( option @ A ) @ ( some @ A @ X ) @ A3 ) ) ).

% in_these_eq
thf(fact_147_selectlike__union,axiom,
    ! [X6: set @ ( variable > real ),Y4: set @ ( variable > real ),Nu: variable > real,V: set @ variable] :
      ( ( static_selectlike @ ( sup_sup @ ( set @ ( variable > real ) ) @ X6 @ Y4 ) @ Nu @ V )
      = ( sup_sup @ ( set @ ( variable > real ) ) @ ( static_selectlike @ X6 @ Nu @ V ) @ ( static_selectlike @ Y4 @ Nu @ V ) ) ) ).

% selectlike_union
thf(fact_148_option_Odistinct_I1_J,axiom,
    ! [A: $tType,X23: A] :
      ( ( none @ A )
     != ( some @ A @ X23 ) ) ).

% option.distinct(1)
thf(fact_149_option_Osel,axiom,
    ! [A: $tType,X23: A] :
      ( ( the @ A @ ( some @ A @ X23 ) )
      = X23 ) ).

% option.sel
thf(fact_150_option_OdiscI,axiom,
    ! [A: $tType,Option: option @ A,X23: A] :
      ( ( Option
        = ( some @ A @ X23 ) )
     => ( Option
       != ( none @ A ) ) ) ).

% option.discI
thf(fact_151_option_Oexhaust,axiom,
    ! [A: $tType,Y: option @ A] :
      ( ( Y
       != ( none @ A ) )
     => ~ ! [X24: A] :
            ( Y
           != ( some @ A @ X24 ) ) ) ).

% option.exhaust
thf(fact_152_option_Oinducts,axiom,
    ! [A: $tType,P: ( option @ A ) > $o,Option: option @ A] :
      ( ( P @ ( none @ A ) )
     => ( ! [X3: A] : ( P @ ( some @ A @ X3 ) )
       => ( P @ Option ) ) ) ).

% option.inducts
thf(fact_153_split__option__ex,axiom,
    ! [A: $tType] :
      ( ( ^ [P2: ( option @ A ) > $o] :
          ? [X7: option @ A] : ( P2 @ X7 ) )
      = ( ^ [P3: ( option @ A ) > $o] :
            ( ( P3 @ ( none @ A ) )
            | ? [X2: A] : ( P3 @ ( some @ A @ X2 ) ) ) ) ) ).

% split_option_ex
thf(fact_154_split__option__all,axiom,
    ! [A: $tType] :
      ( ( ^ [P2: ( option @ A ) > $o] :
          ! [X7: option @ A] : ( P2 @ X7 ) )
      = ( ^ [P3: ( option @ A ) > $o] :
            ( ( P3 @ ( none @ A ) )
            & ! [X2: A] : ( P3 @ ( some @ A @ X2 ) ) ) ) ) ).

% split_option_all
thf(fact_155_combine__options__cases,axiom,
    ! [A: $tType,B: $tType,X: option @ A,P: ( option @ A ) > ( option @ B ) > $o,Y: option @ B] :
      ( ( ( X
          = ( none @ A ) )
       => ( P @ X @ Y ) )
     => ( ( ( Y
            = ( none @ B ) )
         => ( P @ X @ Y ) )
       => ( ! [A6: A,B7: B] :
              ( ( X
                = ( some @ A @ A6 ) )
             => ( ( Y
                  = ( some @ B @ B7 ) )
               => ( P @ X @ Y ) ) )
         => ( P @ X @ Y ) ) ) ) ).

% combine_options_cases
thf(fact_156_ODEo_Oinduct,axiom,
    ! [P: char > ( option @ trm ) > $o,A0: char,A1: option @ trm] :
      ( ! [X3: char,Theta2: trm] : ( P @ X3 @ ( some @ trm @ Theta2 ) )
     => ( ! [X3: char] : ( P @ X3 @ ( none @ trm ) )
       => ( P @ A0 @ A1 ) ) ) ).

% ODEo.induct
thf(fact_157_undeft__equiv,axiom,
    ! [Theta: option @ trm] :
      ( ( Theta
       != ( none @ trm ) )
      = ( ? [T2: trm] :
            ( Theta
            = ( some @ trm @ T2 ) ) ) ) ).

% undeft_equiv
thf(fact_158_Timeso_Oinduct,axiom,
    ! [P: ( option @ trm ) > ( option @ trm ) > $o,A0: option @ trm,A1: option @ trm] :
      ( ! [Theta2: trm,Eta2: trm] : ( P @ ( some @ trm @ Theta2 ) @ ( some @ trm @ Eta2 ) )
     => ( ! [X_1: option @ trm] : ( P @ ( none @ trm ) @ X_1 )
       => ( ! [V2: trm] : ( P @ ( some @ trm @ V2 ) @ ( none @ trm ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% Timeso.induct
thf(fact_159_Assigno_Oinduct,axiom,
    ! [P: variable > ( option @ trm ) > $o,A0: variable,A1: option @ trm] :
      ( ! [X3: variable,Theta2: trm] : ( P @ X3 @ ( some @ trm @ Theta2 ) )
     => ( ! [X3: variable] : ( P @ X3 @ ( none @ trm ) )
       => ( P @ A0 @ A1 ) ) ) ).

% Assigno.induct
thf(fact_160_Differentialo_Ocases,axiom,
    ! [X: option @ trm] :
      ( ! [Theta2: trm] :
          ( X
         != ( some @ trm @ Theta2 ) )
     => ( X
        = ( none @ trm ) ) ) ).

% Differentialo.cases
thf(fact_161_Differentialo_Oinduct,axiom,
    ! [P: ( option @ trm ) > $o,A0: option @ trm] :
      ( ! [Theta2: trm] : ( P @ ( some @ trm @ Theta2 ) )
     => ( ( P @ ( none @ trm ) )
       => ( P @ A0 ) ) ) ).

% Differentialo.induct
thf(fact_162_option_Oexhaust__sel,axiom,
    ! [A: $tType,Option: option @ A] :
      ( ( Option
       != ( none @ A ) )
     => ( Option
        = ( some @ A @ ( the @ A @ Option ) ) ) ) ).

% option.exhaust_sel
thf(fact_163_option_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F1: B,F22: A > B,Option: option @ A] :
      ( ( P @ ( case_option @ B @ A @ F1 @ F22 @ Option ) )
      = ( ( ( Option
            = ( none @ A ) )
         => ( P @ F1 ) )
        & ( ( Option
            = ( some @ A @ ( the @ A @ Option ) ) )
         => ( P @ ( F22 @ ( the @ A @ Option ) ) ) ) ) ) ).

% option.split_sel
thf(fact_164_option_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F1: B,F22: A > B,Option: option @ A] :
      ( ( P @ ( case_option @ B @ A @ F1 @ F22 @ Option ) )
      = ( ~ ( ( ( Option
                = ( none @ A ) )
              & ~ ( P @ F1 ) )
            | ( ( Option
                = ( some @ A @ ( the @ A @ Option ) ) )
              & ~ ( P @ ( F22 @ ( the @ A @ Option ) ) ) ) ) ) ) ).

% option.split_sel_asm
thf(fact_165_option_Osimps_I15_J,axiom,
    ! [A: $tType,X23: A] :
      ( ( set_option @ A @ ( some @ A @ X23 ) )
      = ( insert @ A @ X23 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% option.simps(15)
thf(fact_166_Vagree__repv__self,axiom,
    ! [Omega: variable > real,X: variable,D: real] :
      ( ( denotational_Vagree @ Omega @ ( denotational_repv @ Omega @ X @ D ) @ ( insert @ variable @ X @ ( bot_bot @ ( set @ variable ) ) ) )
      = ( D
        = ( Omega @ X ) ) ) ).

% Vagree_repv_self
thf(fact_167_elem__set,axiom,
    ! [A: $tType,X: A,Xo: option @ A] :
      ( ( member @ A @ X @ ( set_option @ A @ Xo ) )
      = ( Xo
        = ( some @ A @ X ) ) ) ).

% elem_set
thf(fact_168_Vagree__and,axiom,
    ! [Nu: variable > real,Nu2: variable > real,V: set @ variable,W: set @ variable] :
      ( ( ( denotational_Vagree @ Nu @ Nu2 @ V )
        & ( denotational_Vagree @ Nu @ Nu2 @ W ) )
      = ( denotational_Vagree @ Nu @ Nu2 @ ( sup_sup @ ( set @ variable ) @ V @ W ) ) ) ).

% Vagree_and
thf(fact_169_set__empty__eq,axiom,
    ! [A: $tType,Xo: option @ A] :
      ( ( ( set_option @ A @ Xo )
        = ( bot_bot @ ( set @ A ) ) )
      = ( Xo
        = ( none @ A ) ) ) ).

% set_empty_eq
thf(fact_170_similar__selectlike__mem,axiom,
    ! [Nu: variable > real,Omega: variable > real,V: set @ variable,X6: set @ ( variable > real )] :
      ( ( denotational_Vagree @ Nu @ Omega @ V )
     => ( ( member @ ( variable > real ) @ Nu @ ( static_selectlike @ X6 @ Omega @ V ) )
        = ( member @ ( variable > real ) @ Nu @ X6 ) ) ) ).

% similar_selectlike_mem
thf(fact_171_selectlike__Vagree,axiom,
    ! [Nu: variable > real,Omega: variable > real,V: set @ variable,X6: set @ ( variable > real )] :
      ( ( denotational_Vagree @ Nu @ Omega @ V )
     => ( ( static_selectlike @ X6 @ Nu @ V )
        = ( static_selectlike @ X6 @ Omega @ V ) ) ) ).

% selectlike_Vagree
thf(fact_172_Aterm__Some,axiom,
    ( ( some @ trm )
    = ( some @ trm ) ) ).

% Aterm_Some
thf(fact_173_option_Oset__intros,axiom,
    ! [A: $tType,X23: A] : ( member @ A @ X23 @ ( set_option @ A @ ( some @ A @ X23 ) ) ) ).

% option.set_intros
thf(fact_174_option_Oset__cases,axiom,
    ! [A: $tType,E: A,A2: option @ A] :
      ( ( member @ A @ E @ ( set_option @ A @ A2 ) )
     => ( A2
        = ( some @ A @ E ) ) ) ).

% option.set_cases
thf(fact_175_ospec,axiom,
    ! [A: $tType,A3: option @ A,P: A > $o,X: A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ ( set_option @ A @ A3 ) )
         => ( P @ X3 ) )
     => ( ( A3
          = ( some @ A @ X ) )
       => ( P @ X ) ) ) ).

% ospec
thf(fact_176_Vagree__union,axiom,
    ! [Nu: variable > real,Nu2: variable > real,V: set @ variable,W: set @ variable] :
      ( ( denotational_Vagree @ Nu @ Nu2 @ V )
     => ( ( denotational_Vagree @ Nu @ Nu2 @ W )
       => ( denotational_Vagree @ Nu @ Nu2 @ ( sup_sup @ ( set @ variable ) @ V @ W ) ) ) ) ).

% Vagree_union
thf(fact_177_Vagree__def,axiom,
    ( denotational_Vagree
    = ( ^ [Nu3: variable > real,Nu4: variable > real,V3: set @ variable] :
        ! [I: variable] :
          ( ( member @ variable @ I @ V3 )
         => ( ( Nu3 @ I )
            = ( Nu4 @ I ) ) ) ) ) ).

% Vagree_def
thf(fact_178_Vagree__sym,axiom,
    ( denotational_Vagree
    = ( ^ [Nu3: variable > real,Nu4: variable > real] : ( denotational_Vagree @ Nu4 @ Nu3 ) ) ) ).

% Vagree_sym
thf(fact_179_Vagree__refl,axiom,
    ! [Nu: variable > real,V: set @ variable] : ( denotational_Vagree @ Nu @ Nu @ V ) ).

% Vagree_refl
thf(fact_180_Vagree__sym__rel,axiom,
    ! [Nu: variable > real,Nu2: variable > real,V: set @ variable] :
      ( ( denotational_Vagree @ Nu @ Nu2 @ V )
     => ( denotational_Vagree @ Nu2 @ Nu @ V ) ) ).

% Vagree_sym_rel
thf(fact_181_Vagree__empty,axiom,
    ! [Nu: variable > real,Nu2: variable > real] : ( denotational_Vagree @ Nu @ Nu2 @ ( bot_bot @ ( set @ variable ) ) ) ).

% Vagree_empty
thf(fact_182_option_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,F1: B,F22: A > B] :
      ( ( case_option @ B @ A @ F1 @ F22 @ ( none @ A ) )
      = F1 ) ).

% option.simps(4)
thf(fact_183_option_Osimps_I5_J,axiom,
    ! [B: $tType,A: $tType,F1: B,F22: A > B,X23: A] :
      ( ( case_option @ B @ A @ F1 @ F22 @ ( some @ A @ X23 ) )
      = ( F22 @ X23 ) ) ).

% option.simps(5)
thf(fact_184_option_Osimps_I14_J,axiom,
    ! [A: $tType] :
      ( ( set_option @ A @ ( none @ A ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% option.simps(14)
thf(fact_185_option_Oset__sel,axiom,
    ! [A: $tType,A2: option @ A] :
      ( ( A2
       != ( none @ A ) )
     => ( member @ A @ ( the @ A @ A2 ) @ ( set_option @ A @ A2 ) ) ) ).

% option.set_sel
thf(fact_186_option_Ocase__eq__if,axiom,
    ! [A: $tType,B: $tType] :
      ( ( case_option @ B @ A )
      = ( ^ [F12: B,F23: A > B,Option3: option @ A] :
            ( if @ B
            @ ( Option3
              = ( none @ A ) )
            @ F12
            @ ( F23 @ ( the @ A @ Option3 ) ) ) ) ) ).

% option.case_eq_if
thf(fact_187_solves__Vagree,axiom,
    ! [I2: denotational_interp,F3: real > variable > real,X: char,Theta: trm,Zeta: real] :
      ( ( denota1778088425es_ODE @ I2 @ F3 @ X @ Theta )
     => ( denotational_Vagree @ ( F3 @ Zeta ) @ ( F3 @ ( zero_zero @ real ) ) @ ( uminus_uminus @ ( set @ variable ) @ ( insert @ variable @ ( rVar @ X ) @ ( insert @ variable @ ( dVar @ X ) @ ( bot_bot @ ( set @ variable ) ) ) ) ) ) ) ).

% solves_Vagree
thf(fact_188_Vagree__repv,axiom,
    ! [Omega: variable > real,X: variable,D: real] : ( denotational_Vagree @ Omega @ ( denotational_repv @ Omega @ X @ D ) @ ( uminus_uminus @ ( set @ variable ) @ ( insert @ variable @ X @ ( bot_bot @ ( set @ variable ) ) ) ) ) ).

% Vagree_repv
thf(fact_189_Timeso_Osimps_I3_J,axiom,
    ! [V4: trm] :
      ( ( uSubst277968634Timeso @ ( some @ trm @ V4 ) @ ( none @ trm ) )
      = ( none @ trm ) ) ).

% Timeso.simps(3)
thf(fact_190_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A,B3: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = ( uminus_uminus @ A @ B3 ) )
          = ( A2 = B3 ) ) ) ).

% neg_equal_iff_equal
thf(fact_191_add_Oinverse__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ A2 ) )
          = A2 ) ) ).

% add.inverse_inverse
thf(fact_192_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A )
     => ! [X: A,Y: A] :
          ( ( ( uminus_uminus @ A @ X )
            = ( uminus_uminus @ A @ Y ) )
          = ( X = Y ) ) ) ).

% compl_eq_compl_iff
thf(fact_193_double__compl,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A )
     => ! [X: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ X ) )
          = X ) ) ).

% double_compl
thf(fact_194_uminus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A5: A > B,X2: A] : ( uminus_uminus @ B @ ( A5 @ X2 ) ) ) ) ) ).

% uminus_apply
thf(fact_195_Compl__eq__Compl__iff,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A] :
      ( ( ( uminus_uminus @ ( set @ A ) @ A3 )
        = ( uminus_uminus @ ( set @ A ) @ B2 ) )
      = ( A3 = B2 ) ) ).

% Compl_eq_Compl_iff
thf(fact_196_Compl__iff,axiom,
    ! [A: $tType,C2: A,A3: set @ A] :
      ( ( member @ A @ C2 @ ( uminus_uminus @ ( set @ A ) @ A3 ) )
      = ( ~ ( member @ A @ C2 @ A3 ) ) ) ).

% Compl_iff
thf(fact_197_ComplI,axiom,
    ! [A: $tType,C2: A,A3: set @ A] :
      ( ~ ( member @ A @ C2 @ A3 )
     => ( member @ A @ C2 @ ( uminus_uminus @ ( set @ A ) @ A3 ) ) ) ).

% ComplI
thf(fact_198_add_Oinverse__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ( ( uminus_uminus @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% add.inverse_neutral
thf(fact_199_neg__0__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( uminus_uminus @ A @ A2 ) )
          = ( ( zero_zero @ A )
            = A2 ) ) ) ).

% neg_0_equal_iff_equal
thf(fact_200_neg__equal__0__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% neg_equal_0_iff_equal
thf(fact_201_equal__neg__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( A2
            = ( uminus_uminus @ A @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% equal_neg_zero
thf(fact_202_neg__equal__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = A2 )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% neg_equal_zero
thf(fact_203_Uvariation__Vagree,axiom,
    ! [Nu: variable > real,Nu2: variable > real,V: set @ variable] :
      ( ( denota1419872369iation @ Nu @ Nu2 @ ( uminus_uminus @ ( set @ variable ) @ V ) )
      = ( denotational_Vagree @ Nu @ Nu2 @ V ) ) ).

% Uvariation_Vagree
thf(fact_204_minus__equation__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A,B3: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = B3 )
          = ( ( uminus_uminus @ A @ B3 )
            = A2 ) ) ) ).

% minus_equation_iff
thf(fact_205_equation__minus__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A,B3: A] :
          ( ( A2
            = ( uminus_uminus @ A @ B3 ) )
          = ( B3
            = ( uminus_uminus @ A @ A2 ) ) ) ) ).

% equation_minus_iff
thf(fact_206_fun__Compl__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A5: A > B,X2: A] : ( uminus_uminus @ B @ ( A5 @ X2 ) ) ) ) ) ).

% fun_Compl_def
thf(fact_207_double__complement,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( uminus_uminus @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A3 ) )
      = A3 ) ).

% double_complement
thf(fact_208_ComplD,axiom,
    ! [A: $tType,C2: A,A3: set @ A] :
      ( ( member @ A @ C2 @ ( uminus_uminus @ ( set @ A ) @ A3 ) )
     => ~ ( member @ A @ C2 @ A3 ) ) ).

% ComplD
thf(fact_209_Timeso_Osimps_I2_J,axiom,
    ! [Eta: option @ trm] :
      ( ( uSubst277968634Timeso @ ( none @ trm ) @ Eta )
      = ( none @ trm ) ) ).

% Timeso.simps(2)
thf(fact_210_Timeso__undef,axiom,
    ! [Theta: option @ trm,Eta: option @ trm] :
      ( ( ( uSubst277968634Timeso @ Theta @ Eta )
        = ( none @ trm ) )
      = ( ( Theta
          = ( none @ trm ) )
        | ( Eta
          = ( none @ trm ) ) ) ) ).

% Timeso_undef
thf(fact_211_selectlike__equal__cocond__corule,axiom,
    ! [Nu: variable > real,V: set @ variable,X6: set @ ( variable > real ),Y4: set @ ( variable > real )] :
      ( ! [Mu2: variable > real] :
          ( ( denota1419872369iation @ Mu2 @ Nu @ V )
         => ( ( member @ ( variable > real ) @ Mu2 @ X6 )
            = ( member @ ( variable > real ) @ Mu2 @ Y4 ) ) )
     => ( ( static_selectlike @ X6 @ Nu @ ( uminus_uminus @ ( set @ variable ) @ V ) )
        = ( static_selectlike @ Y4 @ Nu @ ( uminus_uminus @ ( set @ variable ) @ V ) ) ) ) ).

% selectlike_equal_cocond_corule
thf(fact_212_selectlike__equal__cocond__rule,axiom,
    ! [Nu: variable > real,V: set @ variable,X6: set @ ( variable > real ),Y4: set @ ( variable > real )] :
      ( ! [Mu2: variable > real] :
          ( ( denota1419872369iation @ Mu2 @ Nu @ ( uminus_uminus @ ( set @ variable ) @ V ) )
         => ( ( member @ ( variable > real ) @ Mu2 @ X6 )
            = ( member @ ( variable > real ) @ Mu2 @ Y4 ) ) )
     => ( ( static_selectlike @ X6 @ Nu @ V )
        = ( static_selectlike @ Y4 @ Nu @ V ) ) ) ).

% selectlike_equal_cocond_rule
thf(fact_213_selectlike__equal__cocond,axiom,
    ! [X6: set @ ( variable > real ),Nu: variable > real,V: set @ variable,Y4: set @ ( variable > real )] :
      ( ( ( static_selectlike @ X6 @ Nu @ ( uminus_uminus @ ( set @ variable ) @ V ) )
        = ( static_selectlike @ Y4 @ Nu @ ( uminus_uminus @ ( set @ variable ) @ V ) ) )
      = ( ! [Mu3: variable > real] :
            ( ( denota1419872369iation @ Mu3 @ Nu @ V )
           => ( ( member @ ( variable > real ) @ Mu3 @ X6 )
              = ( member @ ( variable > real ) @ Mu3 @ Y4 ) ) ) ) ) ).

% selectlike_equal_cocond
thf(fact_214_selectlike__equal__cond,axiom,
    ! [X6: set @ ( variable > real ),Nu: variable > real,V: set @ variable,Y4: set @ ( variable > real )] :
      ( ( ( static_selectlike @ X6 @ Nu @ V )
        = ( static_selectlike @ Y4 @ Nu @ V ) )
      = ( ! [Mu3: variable > real] :
            ( ( denota1419872369iation @ Mu3 @ Nu @ ( uminus_uminus @ ( set @ variable ) @ V ) )
           => ( ( member @ ( variable > real ) @ Mu3 @ X6 )
              = ( member @ ( variable > real ) @ Mu3 @ Y4 ) ) ) ) ) ).

% selectlike_equal_cond
thf(fact_215_stateinterpol__insert,axiom,
    ! [V4: variable > real,W2: variable > real,S: set @ variable,Z: variable] : ( denotational_Vagree @ ( stateinterpol @ V4 @ W2 @ S ) @ ( stateinterpol @ V4 @ W2 @ ( insert @ variable @ Z @ S ) ) @ ( uminus_uminus @ ( set @ variable ) @ ( insert @ variable @ Z @ ( bot_bot @ ( set @ variable ) ) ) ) ) ).

% stateinterpol_insert
thf(fact_216_Timeso_Oelims,axiom,
    ! [X: option @ trm,Xa: option @ trm,Y: option @ trm] :
      ( ( ( uSubst277968634Timeso @ X @ Xa )
        = Y )
     => ( ! [Theta2: trm] :
            ( ( X
              = ( some @ trm @ Theta2 ) )
           => ! [Eta2: trm] :
                ( ( Xa
                  = ( some @ trm @ Eta2 ) )
               => ( Y
                 != ( some @ trm @ ( times @ Theta2 @ Eta2 ) ) ) ) )
       => ( ( ( X
              = ( none @ trm ) )
           => ( Y
             != ( none @ trm ) ) )
         => ~ ( ? [V2: trm] :
                  ( X
                  = ( some @ trm @ V2 ) )
             => ( ( Xa
                  = ( none @ trm ) )
               => ( Y
                 != ( none @ trm ) ) ) ) ) ) ) ).

% Timeso.elims
thf(fact_217_trm_Oinject_I6_J,axiom,
    ! [X61: trm,X62: trm,Y61: trm,Y62: trm] :
      ( ( ( times @ X61 @ X62 )
        = ( times @ Y61 @ Y62 ) )
      = ( ( X61 = Y61 )
        & ( X62 = Y62 ) ) ) ).

% trm.inject(6)
thf(fact_218_stateinterpol__left,axiom,
    ! [X: variable,S: set @ variable,Nu: variable > real,Omega: variable > real] :
      ( ( member @ variable @ X @ S )
     => ( ( stateinterpol @ Nu @ Omega @ S @ X )
        = ( Nu @ X ) ) ) ).

% stateinterpol_left
thf(fact_219_stateinterpol__right,axiom,
    ! [X: variable,S: set @ variable,Nu: variable > real,Omega: variable > real] :
      ( ~ ( member @ variable @ X @ S )
     => ( ( stateinterpol @ Nu @ Omega @ S @ X )
        = ( Omega @ X ) ) ) ).

% stateinterpol_right
thf(fact_220_selectlike__co__selectlike,axiom,
    ! [X6: set @ ( variable > real ),Nu: variable > real,V: set @ variable] :
      ( ( static_selectlike @ ( uminus_uminus @ ( set @ ( variable > real ) ) @ ( static_selectlike @ X6 @ Nu @ V ) ) @ Nu @ V )
      = ( static_selectlike @ ( uminus_uminus @ ( set @ ( variable > real ) ) @ X6 ) @ Nu @ V ) ) ).

% selectlike_co_selectlike
thf(fact_221_stateinterpol__empty,axiom,
    ! [Nu: variable > real,Omega: variable > real] :
      ( ( stateinterpol @ Nu @ Omega @ ( bot_bot @ ( set @ variable ) ) )
      = Omega ) ).

% stateinterpol_empty
thf(fact_222_Vagree__stateinterpol,axiom,
    ! [Nu: variable > real,Omega: variable > real,S: set @ variable] : ( denotational_Vagree @ ( stateinterpol @ Nu @ Omega @ S ) @ Nu @ S ) ).

% Vagree_stateinterpol
thf(fact_223_stateinterpol__def,axiom,
    ( stateinterpol
    = ( ^ [Nu3: variable > real,Omega2: variable > real,S2: set @ variable,X2: variable] : ( if @ real @ ( member @ variable @ X2 @ S2 ) @ ( Nu3 @ X2 ) @ ( Omega2 @ X2 ) ) ) ) ).

% stateinterpol_def
thf(fact_224_usubstappt__times__conv,axiom,
    ! [Sigma: product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ),U: set @ variable,Theta: trm,Eta: trm] :
      ( ( ( uSubst95898992stappt @ Sigma @ U @ ( times @ Theta @ Eta ) )
       != ( none @ trm ) )
     => ( ( ( uSubst95898992stappt @ Sigma @ U @ Theta )
         != ( none @ trm ) )
        & ( ( uSubst95898992stappt @ Sigma @ U @ Eta )
         != ( none @ trm ) ) ) ) ).

% usubstappt_times_conv
thf(fact_225_usubstappt_Osimps_I6_J,axiom,
    ! [Sigma: product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ trm ) ) @ ( product_prod @ ( char > ( option @ fml ) ) @ ( char > ( option @ game ) ) ) ),U: set @ variable,Theta: trm,Eta: trm] :
      ( ( uSubst95898992stappt @ Sigma @ U @ ( times @ Theta @ Eta ) )
      = ( uSubst277968634Timeso @ ( uSubst95898992stappt @ Sigma @ U @ Theta ) @ ( uSubst95898992stappt @ Sigma @ U @ Eta ) ) ) ).

% usubstappt.simps(6)
thf(fact_226_Timeso_Osimps_I1_J,axiom,
    ! [Theta: trm,Eta: trm] :
      ( ( uSubst277968634Timeso @ ( some @ trm @ Theta ) @ ( some @ trm @ Eta ) )
      = ( some @ trm @ ( times @ Theta @ Eta ) ) ) ).

% Timeso.simps(1)
thf(fact_227_stateinterpol__diff,axiom,
    ! [Nu: variable > real,Omega: variable > real] :
      ( ( stateinterpol @ Nu @ Omega @ ( statediff @ Nu @ Omega ) )
      = Nu ) ).

% stateinterpol_diff
thf(fact_228_stateinterpol__FVT,axiom,
    ! [Z: variable,T3: trm,I2: denotational_interp,Omega: variable > real,Omega3: variable > real,S: set @ variable] :
      ( ~ ( member @ variable @ Z @ ( static_FVT @ T3 ) )
     => ( ( denota1863255036rm_sem @ I2 @ T3 @ ( stateinterpol @ Omega @ Omega3 @ S ) )
        = ( denota1863255036rm_sem @ I2 @ T3 @ ( stateinterpol @ Omega @ Omega3 @ ( insert @ variable @ Z @ S ) ) ) ) ) ).

% stateinterpol_FVT
thf(fact_229_nostatediff,axiom,
    ! [X: variable,Nu: variable > real,Omega: variable > real] :
      ( ~ ( member @ variable @ X @ ( statediff @ Nu @ Omega ) )
     => ( ( Nu @ X )
        = ( Omega @ X ) ) ) ).

% nostatediff
thf(fact_230_coincidence__term,axiom,
    ! [Omega: variable > real,Omega3: variable > real,Theta: trm,I2: denotational_interp] :
      ( ( denotational_Vagree @ Omega @ Omega3 @ ( static_FVT @ Theta ) )
     => ( ( denota1863255036rm_sem @ I2 @ Theta @ Omega )
        = ( denota1863255036rm_sem @ I2 @ Theta @ Omega3 ) ) ) ).

% coincidence_term
thf(fact_231_coincidence__term__cor,axiom,
    ! [Omega: variable > real,Omega3: variable > real,U: set @ variable,Theta: trm,I2: denotational_interp] :
      ( ( denota1419872369iation @ Omega @ Omega3 @ U )
     => ( ( ( inf_inf @ ( set @ variable ) @ ( static_FVT @ Theta ) @ U )
          = ( bot_bot @ ( set @ variable ) ) )
       => ( ( denota1863255036rm_sem @ I2 @ Theta @ Omega )
          = ( denota1863255036rm_sem @ I2 @ Theta @ Omega3 ) ) ) ) ).

% coincidence_term_cor
thf(fact_232_Vagree__statediff,axiom,
    ! [Omega: variable > real,Omega3: variable > real,S: set @ variable] :
      ( ( denotational_Vagree @ Omega @ Omega3 @ S )
     => ( ord_less_eq @ ( set @ variable ) @ ( statediff @ Omega @ Omega3 ) @ ( uminus_uminus @ ( set @ variable ) @ S ) ) ) ).

% Vagree_statediff
thf(fact_233_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_234_subsetI,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A3 )
         => ( member @ A @ X3 @ B2 ) )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ B2 ) ) ).

% subsetI
thf(fact_235_subset__antisym,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ A3 )
       => ( A3 = B2 ) ) ) ).

% subset_antisym
thf(fact_236_inf__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_inf @ B )
     => ( ( inf_inf @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X2: A] : ( inf_inf @ B @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ) ).

% inf_apply
thf(fact_237_inf_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [A2: A] :
          ( ( inf_inf @ A @ A2 @ A2 )
          = A2 ) ) ).

% inf.idem
thf(fact_238_inf__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [X: A] :
          ( ( inf_inf @ A @ X @ X )
          = X ) ) ).

% inf_idem
thf(fact_239_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [A2: A,B3: A] :
          ( ( inf_inf @ A @ A2 @ ( inf_inf @ A @ A2 @ B3 ) )
          = ( inf_inf @ A @ A2 @ B3 ) ) ) ).

% inf.left_idem
thf(fact_240_inf__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_left_idem
thf(fact_241_inf_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [A2: A,B3: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A2 @ B3 ) @ B3 )
          = ( inf_inf @ A @ A2 @ B3 ) ) ) ).

% inf.right_idem
thf(fact_242_inf__right__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Y )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_right_idem
thf(fact_243_IntI,axiom,
    ! [A: $tType,C2: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ A3 )
     => ( ( member @ A @ C2 @ B2 )
       => ( member @ A @ C2 @ ( inf_inf @ ( set @ A ) @ A3 @ B2 ) ) ) ) ).

% IntI
thf(fact_244_Int__iff,axiom,
    ! [A: $tType,C2: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( inf_inf @ ( set @ A ) @ A3 @ B2 ) )
      = ( ( member @ A @ C2 @ A3 )
        & ( member @ A @ C2 @ B2 ) ) ) ).

% Int_iff
thf(fact_245_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_246_neg__le__iff__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [B3: A,A2: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ B3 ) @ ( uminus_uminus @ A @ A2 ) )
          = ( ord_less_eq @ A @ A2 @ B3 ) ) ) ).

% neg_le_iff_le
thf(fact_247_compl__le__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ X ) @ ( uminus_uminus @ A @ Y ) )
          = ( ord_less_eq @ A @ Y @ X ) ) ) ).

% compl_le_compl_iff
thf(fact_248_le__inf__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% le_inf_iff
thf(fact_249_inf_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( inf_inf @ A @ B3 @ C2 ) )
          = ( ( ord_less_eq @ A @ A2 @ B3 )
            & ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% inf.bounded_iff
thf(fact_250_le__sup__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ ( sup_sup @ A @ X @ Y ) @ Z )
          = ( ( ord_less_eq @ A @ X @ Z )
            & ( ord_less_eq @ A @ Y @ Z ) ) ) ) ).

% le_sup_iff
thf(fact_251_sup_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A )
     => ! [B3: A,C2: A,A2: A] :
          ( ( ord_less_eq @ A @ ( sup_sup @ A @ B3 @ C2 ) @ A2 )
          = ( ( ord_less_eq @ A @ B3 @ A2 )
            & ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% sup.bounded_iff
thf(fact_252_empty__subsetI,axiom,
    ! [A: $tType,A3: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A3 ) ).

% empty_subsetI
thf(fact_253_subset__empty,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ ( bot_bot @ ( set @ A ) ) )
      = ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_empty

% Type constructors (44)
thf(tcon_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice @ $o ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice_1,axiom,
    ! [A7: $tType] : ( bounded_lattice @ ( set @ A7 ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice_2,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bounded_lattice @ A8 )
     => ( bounded_lattice @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Lattices_Obounded__semilattice__sup__bot,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bounded_lattice @ A8 )
     => ( bounde1808546759up_bot @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Lattices_Osemilattice__sup,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( semilattice_sup @ A8 )
     => ( semilattice_sup @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Lattices_Osemilattice__inf,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( semilattice_inf @ A8 )
     => ( semilattice_inf @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( boolean_algebra @ A8 )
     => ( boolean_algebra @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 )
     => ( preorder @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( lattice @ A8 )
     => ( lattice @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bot @ A8 )
     => ( bot @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Groups_Ouminus,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( uminus @ A8 )
     => ( uminus @ ( A7 > A8 ) ) ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Lattices_Osemilattice__sup_3,axiom,
    semilattice_sup @ nat ).

thf(tcon_Nat_Onat___Lattices_Osemilattice__inf_4,axiom,
    semilattice_inf @ nat ).

thf(tcon_Nat_Onat___Orderings_Opreorder_5,axiom,
    preorder @ nat ).

thf(tcon_Nat_Onat___Lattices_Olattice_6,axiom,
    lattice @ nat ).

thf(tcon_Nat_Onat___Orderings_Obot_7,axiom,
    bot @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat ).

thf(tcon_Set_Oset___Lattices_Obounded__semilattice__sup__bot_8,axiom,
    ! [A7: $tType] : ( bounde1808546759up_bot @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__sup_9,axiom,
    ! [A7: $tType] : ( semilattice_sup @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__inf_10,axiom,
    ! [A7: $tType] : ( semilattice_inf @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_11,axiom,
    ! [A7: $tType] : ( boolean_algebra @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_12,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Lattices_Olattice_13,axiom,
    ! [A7: $tType] : ( lattice @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_14,axiom,
    ! [A7: $tType] : ( bot @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Groups_Ouminus_15,axiom,
    ! [A7: $tType] : ( uminus @ ( set @ A7 ) ) ).

thf(tcon_Set_Oset___Groups_Ozero_16,axiom,
    ! [A7: $tType] :
      ( ( zero @ A7 )
     => ( zero @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__semilattice__sup__bot_17,axiom,
    bounde1808546759up_bot @ $o ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__sup_18,axiom,
    semilattice_sup @ $o ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__inf_19,axiom,
    semilattice_inf @ $o ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_20,axiom,
    boolean_algebra @ $o ).

thf(tcon_HOL_Obool___Orderings_Opreorder_21,axiom,
    preorder @ $o ).

thf(tcon_HOL_Obool___Lattices_Olattice_22,axiom,
    lattice @ $o ).

thf(tcon_HOL_Obool___Orderings_Obot_23,axiom,
    bot @ $o ).

thf(tcon_HOL_Obool___Groups_Ouminus_24,axiom,
    uminus @ $o ).

thf(tcon_Real_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add @ real ).

thf(tcon_Real_Oreal___Lattices_Osemilattice__sup_25,axiom,
    semilattice_sup @ real ).

thf(tcon_Real_Oreal___Lattices_Osemilattice__inf_26,axiom,
    semilattice_inf @ real ).

thf(tcon_Real_Oreal___Orderings_Opreorder_27,axiom,
    preorder @ real ).

thf(tcon_Real_Oreal___Lattices_Olattice_28,axiom,
    lattice @ real ).

thf(tcon_Real_Oreal___Groups_Ogroup__add,axiom,
    group_add @ real ).

thf(tcon_Real_Oreal___Groups_Ouminus_29,axiom,
    uminus @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_30,axiom,
    zero @ real ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    denota1419872369iation @ ( f @ ( zero_zero @ real ) ) @ omega @ ( sup_sup @ ( set @ variable ) @ ( insert @ variable @ ( rVar @ x ) @ ( insert @ variable @ ( dVar @ x ) @ ( bot_bot @ ( set @ variable ) ) ) ) @ u ) ).

%------------------------------------------------------------------------------
